<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Empresa extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $fillable = [
        'name',
        'email',
        'password',
        'contact_name',
        'phone',
        'city',
        'state',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected function casts(): array
    {
        return [
            'password' => 'hashed',
        ];
    }

    public function protocolos()
    {
        return $this->belongsToMany(Protocolo::class, 'empresa_protocolo')
            ->withPivot(['ativo', 'token'])
            ->withTimestamps();
    }

    public function setores()
    {
        return $this->hasMany(Setor::class);
    }
}
