<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class EmpresaProtocoloPeriodo extends Model
{
    protected $fillable = [
        'empresa_protocolo_id',
        'inicio',
        'fim',
        'token',
        'cpfs',
    ];

    protected $casts = [
        'inicio' => 'date',
        'fim' => 'date',
    ];

    public function empresaProtocolo()
    {
        return $this->belongsTo(EmpresaProtocolo::class);
    }

    public function cpfList()
    {
        return collect(preg_split("/\r\n|\n|\r/", (string) $this->cpfs))
            ->map(fn($cpf) => preg_replace('/\D/', '', $cpf))
            ->filter()
            ->values();
    }
}
