<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Pergunta extends Model
{
    protected $fillable = [
        'protocolo_id',
        'ordem',
        'texto',
    ];

    public function protocolo()
    {
        return $this->belongsTo(Protocolo::class);
    }

    public function opcoes()
    {
        return $this->hasMany(PerguntaOpcao::class);
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (is_null($model->ordem)) {
                $maxOrder = self::where('protocolo_id', $model->protocolo_id)->max('ordem');
                $model->ordem = is_null($maxOrder) ? 1 : $maxOrder + 1;
            }
        });
    }
}
