@extends('layouts.empresas')

@section('title', 'Protocolos')

@section('content')
<div class="max-w-5xl mx-auto">
    <h1 class="text-2xl font-semibold mb-6">Protocolos Disponíveis</h1>
    <table class="w-full bg-white border border-gray-200 rounded-lg overflow-hidden">
        <thead class="bg-gray-50">
            <tr>
                <th class="px-4 py-2 text-left text-sm font-medium text-gray-700">Protocolo</th>
                <th class="px-4 py-2 text-left text-sm font-medium text-gray-700">Status</th>
                <th class="px-4 py-2 text-left text-sm font-medium text-gray-700">Link de Resposta</th>
            </tr>
        </thead>
        <tbody>
            @foreach($protocolos as $protocolo)
                @php
                    $pivot = $empresaProtocolos[$protocolo->id] ?? null;
                @endphp
                <tr class="border-t border-gray-200">
                    <td class="px-4 py-2 text-gray-900">{{ $protocolo->nome }}</td>
                    <td class="px-4 py-2">
                        <form method="POST" action="{{ route('empresa.protocolos.toggle', $protocolo) }}">
                            @csrf
                            <input type="hidden" name="ativo" value="{{ $pivot && $pivot->ativo ? 0 : 1 }}">
                            <button type="submit" class="px-3 py-1 rounded-md text-sm {{ $pivot && $pivot->ativo ? 'bg-green-600 text-white' : 'bg-gray-200 text-gray-700' }}">
                                {{ $pivot && $pivot->ativo ? 'Ativo' : 'Inativo' }}
                            </button>
                        </form>
                    </td>
                    <td class="px-4 py-2">
                        @if($pivot && $pivot->ativo)
                            @foreach($pivot->periodos as $periodo)
                                <div class="mt-2">
                                    <div class="flex items-center justify-between">
                                        <span class="text-xs">{{ $periodo->inicio->format('d/m/Y') }} - {{ $periodo->fim->format('d/m/Y') }}</span>
                                        <form method="POST" action="{{ route('empresa.protocolos.periodos.destroy', $periodo) }}">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-red-600 text-xs">Excluir</button>
                                        </form>
                                    </div>
                                    <input type="text" readonly class="mt-1 w-full text-sm border rounded px-2 py-1" value="{{ route('protocolo.responder', $periodo->token) }}">
                                    <button type="button" class="text-blue-600 text-xs mt-1" onclick='openCpfModal("{{ route('empresa.protocolos.periodos.cpfs.store', $periodo) }}", @json($periodo->cpfs))'>Informar CPFs</button>
                                </div>
                            @endforeach
                            <form method="POST" action="{{ route('empresa.protocolos.periodos.store', $protocolo) }}" class="mt-2 flex flex-col gap-2">
                                @csrf
                                <div class="flex gap-2">
                                    <input type="text" name="inicio" placeholder="dd/mm/aaaa" class="border rounded px-2 py-1 text-sm" required>
                                    <input type="text" name="fim" placeholder="dd/mm/aaaa" class="border rounded px-2 py-1 text-sm" required>
                                </div>
                                <button type="submit" class="px-3 py-1 bg-blue-600 text-white rounded-md text-sm">Adicionar Período</button>
                            </form>
                        @else
                            <span class="text-sm text-gray-500">Ative o protocolo para criar períodos.</span>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>

<div id="cpfModal" class="fixed inset-0 bg-black bg-opacity-50 hidden flex items-center justify-center">
    <div class="bg-white p-4 rounded shadow max-w-md w-full">
        <form id="cpfForm" method="POST" class="flex flex-col">
            @csrf
            <textarea id="cpfField" name="cpfs" class="border rounded p-2 h-40" placeholder="Digite um CPF por linha"></textarea>
            <div class="mt-4 flex justify-end gap-2">
                <button type="button" onclick="closeCpfModal()" class="px-3 py-1 border rounded">Cancelar</button>
                <button type="submit" class="px-3 py-1 bg-blue-600 text-white rounded">Salvar</button>
            </div>
        </form>
    </div>
</div>

<script>
function openCpfModal(action, cpfs) {
    document.getElementById('cpfModal').classList.remove('hidden');
    const form = document.getElementById('cpfForm');
    form.action = action;
    document.getElementById('cpfField').value = cpfs ? cpfs : '';
}
function closeCpfModal() {
    document.getElementById('cpfModal').classList.add('hidden');
}
</script>
@endsection
