<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\EmpresaController;
use App\Http\Controllers\EmpresaAuthController;
use App\Http\Controllers\EmpresaProtocoloController;
use App\Http\Controllers\SetorController;
use App\Http\Controllers\PerguntaController;
use App\Http\Controllers\PerguntaOpcaoController;
use App\Http\Controllers\ProtocoloController;
use App\Http\Controllers\ProtocoloRespostaController;
use App\Http\Controllers\RelatorioController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return redirect()->route('login');
});

Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::get('/register', [AuthController::class, 'showRegisterForm'])->name('register');
Route::post('/register', [AuthController::class, 'register']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

Route::get('/empresa/login', [EmpresaAuthController::class, 'showLoginForm'])->name('empresa.login');
Route::post('/empresa/login', [EmpresaAuthController::class, 'login']);
Route::post('/empresa/logout', [EmpresaAuthController::class, 'logout'])->name('empresa.logout');

Route::middleware('auth')->group(function () {
    Route::get('/dashboard/gestao', [DashboardController::class, 'gestao'])->name('dashboard.gestao');
    Route::resource('usuarios', UserController::class);
    Route::resource('empresas', EmpresaController::class);
    Route::resource('protocolos', ProtocoloController::class);
    Route::get('protocolos/{protocolo}/perguntas', [ProtocoloController::class, 'perguntas'])->name('protocolos.perguntas');
    Route::post('protocolos/{protocolo}/perguntas', [PerguntaController::class, 'store'])->name('protocolos.perguntas.store');
    Route::get('protocolos/{protocolo}/perguntas/{pergunta}/edit', [PerguntaController::class, 'edit'])->name('protocolos.perguntas.edit');
    Route::put('protocolos/{protocolo}/perguntas/{pergunta}', [PerguntaController::class, 'update'])->name('protocolos.perguntas.update');
    Route::delete('protocolos/{protocolo}/perguntas/{pergunta}', [PerguntaController::class, 'destroy'])->name('protocolos.perguntas.destroy');
    Route::delete('protocolos/{protocolo}/perguntas/{pergunta}/opcoes/{opcao}', [PerguntaOpcaoController::class, 'destroy'])->name('protocolos.perguntas.opcoes.destroy');
});

Route::middleware('auth:web,empresa')->group(function () {
    Route::resource('empresas.setores', SetorController::class);
});

Route::middleware('auth:empresa')->group(function () {
    Route::get('empresa/protocolos', [EmpresaProtocoloController::class, 'index'])->name('empresa.protocolos.index');
    Route::post('empresa/protocolos/{protocolo}/toggle', [EmpresaProtocoloController::class, 'toggle'])->name('empresa.protocolos.toggle');
    Route::post('empresa/protocolos/{protocolo}/periodos', [EmpresaProtocoloController::class, 'storePeriodo'])->name('empresa.protocolos.periodos.store');
    Route::delete('empresa/protocolos/periodos/{periodo}', [EmpresaProtocoloController::class, 'destroyPeriodo'])->name('empresa.protocolos.periodos.destroy');
    Route::post('empresa/protocolos/periodos/{periodo}/cpfs', [EmpresaProtocoloController::class, 'storeCpfs'])->name('empresa.protocolos.periodos.cpfs.store');
});

Route::get('r/{token}', [ProtocoloRespostaController::class, 'show'])->name('protocolo.responder');
Route::post('r/{token}', [ProtocoloRespostaController::class, 'store'])->name('protocolo.responder.salvar');
Route::post('r/{token}/check-cpf', [ProtocoloRespostaController::class, 'checkCpf'])->name('protocolo.responder.check');

Route::get('/dashboard/resultados', [DashboardController::class, 'resultados'])
    ->name('dashboard.resultados')
    ->middleware('auth:web,empresa');

Route::get('/relatorios', [RelatorioController::class, 'index'])
    ->name('relatorios.index')
    ->middleware('auth:web,empresa');
