<?php echo csrf_field(); ?>
<?php if(isset($protocolo)): ?>
    <?php echo method_field('PUT'); ?>
<?php endif; ?>
<div class="grid grid-cols-1 gap-4">
    <div>
        <label for="nome" class="block text-sm font-medium text-gray-700">Nome <span class="text-red-600">*</span></label>
        <input id="nome" name="nome" type="text" value="<?php echo e(old('nome', $protocolo->nome ?? '')); ?>" required class="w-full rounded-lg border border-gray-300 px-3 py-2">
    </div>
    <div>
        <label for="introducao" class="block text-sm font-medium text-gray-700">Texto de Introdução</label>
        <textarea id="introducao" name="introducao" class="w-full rounded-lg border border-gray-300 px-3 py-2" rows="3"><?php echo e(old('introducao', $protocolo->introducao ?? '')); ?></textarea>
    </div>
    <div>
        <label for="status" class="block text-sm font-medium text-gray-700">Status <span class="text-red-600">*</span></label>
        <select id="status" name="status" class="w-full rounded-lg border border-gray-300 px-3 py-2">
            <option value="1" <?php echo e(old('status', $protocolo->status ?? true) ? 'selected' : ''); ?>>Ativo</option>
            <option value="0" <?php echo e(old('status', $protocolo->status ?? true) ? '' : 'selected'); ?>>Inativo</option>
        </select>
    </div>
    <div>
        <label for="categoria" class="block text-sm font-medium text-gray-700">Tipo <span class="text-red-600">*</span></label>
        <select id="categoria" name="categoria" class="w-full rounded-lg border border-gray-300 px-3 py-2">
            <option value="protocolo" <?php echo e(old('categoria', $protocolo->categoria ?? 'protocolo') === 'protocolo' ? 'selected' : ''); ?>>Protocolo</option>
            <option value="pesquisa" <?php echo e(old('categoria', $protocolo->categoria ?? 'protocolo') === 'pesquisa' ? 'selected' : ''); ?>>Pesquisa</option>
        </select>
    </div>
    <div>
        <label for="visivel_empresas" class="block text-sm font-medium text-gray-700">Visível para empresas <span class="text-red-600">*</span></label>
        <select id="visivel_empresas" name="visivel_empresas" class="w-full rounded-lg border border-gray-300 px-3 py-2">
            <option value="1" <?php echo e(old('visivel_empresas', $protocolo->visivel_empresas ?? true) ? 'selected' : ''); ?>>Sim</option>
            <option value="0" <?php echo e(old('visivel_empresas', $protocolo->visivel_empresas ?? true) ? '' : 'selected'); ?>>Não</option>
        </select>
    </div>
    <div>
        <label for="tipo" class="block text-sm font-medium text-gray-700">Tipo de pontuação <span class="text-red-600">*</span></label>
        <select id="tipo" name="tipo" class="w-full rounded-lg border border-gray-300 px-3 py-2">
            <option value="simples" <?php echo e(old('tipo', $protocolo->tipo ?? '') === 'simples' ? 'selected' : ''); ?>>Simples</option>
            <option value="par_impar" <?php echo e(old('tipo', $protocolo->tipo ?? '') === 'par_impar' ? 'selected' : ''); ?>>Par/Ímpar</option>
        </select>
    </div>
    <div class="flex items-center gap-2">
        <input id="permitir_pf" name="permitir_pf" type="checkbox" value="1" <?php echo e(old('permitir_pf', $protocolo->permitir_pf ?? false) ? 'checked' : ''); ?> class="rounded border-gray-300 text-blue-600 focus:ring-blue-500">
        <label for="permitir_pf" class="text-sm font-medium text-gray-700">Permitir PF</label>
    </div>
</div>

<div class="mt-6">
    <h2 class="text-base font-semibold text-gray-900">Resultados</h2>
    <?php
        $resultados = old('resultados', isset($protocolo) ? $protocolo->resultados->toArray() : [[]]);
    ?>
    <div id="resultados-container" class="space-y-4 mt-4">
        <?php $__currentLoopData = $resultados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $resultado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="resultado flex flex-col gap-2 bg-gray-50 p-4 rounded-lg">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Pontuação De</label>
                        <input type="number" name="resultados[<?php echo e($i); ?>][pontuacao_de]" value="<?php echo e($resultado['pontuacao_de'] ?? ''); ?>" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Pontuação Até</label>
                        <input type="number" name="resultados[<?php echo e($i); ?>][pontuacao_ate]" value="<?php echo e($resultado['pontuacao_ate'] ?? ''); ?>" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Rótulo</label>
                        <input type="text" name="resultados[<?php echo e($i); ?>][rotulo]" value="<?php echo e($resultado['rotulo'] ?? ''); ?>" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Paridade</label>
                        <select name="resultados[<?php echo e($i); ?>][paridade]" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                            <option value="geral" <?php echo e(($resultado['paridade'] ?? '') === 'geral' ? 'selected' : ''); ?>>Geral</option>
                            <option value="par" <?php echo e(($resultado['paridade'] ?? '') === 'par' ? 'selected' : ''); ?>>Par</option>
                            <option value="impar" <?php echo e(($resultado['paridade'] ?? '') === 'impar' ? 'selected' : ''); ?>>Ímpar</option>
                        </select>
                    </div>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Texto</label>
                    <textarea name="resultados[<?php echo e($i); ?>][texto]" class="w-full rounded-lg border border-gray-300 px-3 py-2" rows="2"><?php echo e($resultado['texto'] ?? ''); ?></textarea>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <button type="button" id="add-resultado" class="mt-2 inline-flex items-center gap-2 text-sm px-3 py-2 rounded-lg border border-gray-200 text-gray-700 hover:bg-gray-50">Adicionar Resultado</button>
</div>

<div class="pt-4 border-t border-gray-200 flex items-center justify-end gap-2">
    <a href="<?php echo e(route('protocolos.index')); ?>" class="inline-flex items-center gap-2 text-sm px-4 py-2 rounded-lg border border-gray-200 text-gray-700 hover:bg-gray-50">Cancelar</a>
    <button type="submit" class="inline-flex items-center gap-2 text-sm px-4 py-2 rounded-lg bg-green-600 text-white hover:bg-green-700">Salvar</button>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        let index = <?php echo e(count($resultados)); ?>;
        const container = document.getElementById('resultados-container');
        document.getElementById('add-resultado').addEventListener('click', function () {
            const div = document.createElement('div');
            div.classList.add('resultado','flex','flex-col','gap-2','bg-gray-50','p-4','rounded-lg');
            div.innerHTML = `
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Pontuação De</label>
                        <input type="number" name="resultados[${index}][pontuacao_de]" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Pontuação Até</label>
                        <input type="number" name="resultados[${index}][pontuacao_ate]" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Rótulo</label>
                        <input type="text" name="resultados[${index}][rotulo]" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700">Paridade</label>
                        <select name="resultados[${index}][paridade]" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                            <option value="geral">Geral</option>
                            <option value="par">Par</option>
                            <option value="impar">Ímpar</option>
                        </select>
                    </div>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Texto</label>
                    <textarea name="resultados[${index}][texto]" class="w-full rounded-lg border border-gray-300 px-3 py-2" rows="2"></textarea>
                </div>`;
            container.appendChild(div);
            index++;
        });
    });
</script>
<?php /**PATH /Users/mac/Documents/projetos/AzoProtocolo/resources/views/protocolos/_form.blade.php ENDPATH**/ ?>