<aside id="sidebar" class="fixed inset-y-0 left-0 z-50 w-72 bg-white border-r border-gray-200 transform -translate-x-full transition-transform duration-300 ease-in-out lg:translate-x-0">
  <div class="h-16 flex items-center px-5 bg-gradient-to-r   text-white" style="background-color: #090c52">
    <i class=""><img src="/logo-white.png" style="width: 70px"></i>
    <span class="font-semibold tracking-wide">Saúde Mental</span>
  </div>
  <nav class="py-4">
    <div class="px-3 space-y-1">
      <a href="<?php echo e(route('dashboard.resultados')); ?>" class="w-full flex items-center gap-3 px-3 py-2 rounded-lg text-sm font-medium <?php echo e(request()->routeIs('dashboard.resultados') ? 'text-gray-700 bg-primary-50 border border-primary-100' : 'text-gray-600 hover:bg-gray-100'); ?>">
        <i class="fa-solid fa-gauge-high <?php echo e(request()->routeIs('dashboard.resultados') ? 'text-primary-600' : ''); ?>"></i><span>Dashboard</span>
      </a>
      <a href="<?php echo e(route('relatorios.index')); ?>" class="w-full flex items-center gap-3 px-3 py-2 rounded-lg text-sm font-medium <?php echo e(request()->routeIs('relatorios.*') ? 'text-gray-700 bg-primary-50 border border-primary-100' : 'text-gray-600 hover:bg-gray-100'); ?>">
        <i class="fa-solid fa-chart-line <?php echo e(request()->routeIs('relatorios.*') ? 'text-primary-600' : ''); ?>"></i><span>Relatórios</span>
      </a>
      <a href="<?php echo e(route('empresa.protocolos.index')); ?>" class="w-full flex items-center gap-3 px-3 py-2 rounded-lg text-sm font-medium <?php echo e(request()->routeIs('empresa.protocolos.*') ? 'text-gray-700 bg-primary-50 border border-primary-100' : 'text-gray-600 hover:bg-gray-100'); ?>">
        <i class="fa-solid fa-clipboard-list"></i><span>Protocolos</span>
      </a>
      <a href="<?php echo e(route('empresas.setores.index', auth('empresa')->user())); ?>" class="w-full flex items-center gap-3 px-3 py-2 rounded-lg text-sm font-medium <?php echo e(request()->routeIs('empresas.setores.*') ? 'text-gray-700 bg-primary-50 border border-primary-100' : 'text-gray-600 hover:bg-gray-100'); ?>">
        <i class="fa-solid fa-diagram-project"></i><span>Setores</span>
      </a>
    </div>
  </nav>
  <div class="absolute bottom-0 w-full p-4 border-t border-gray-200">
    <?php
        $currentUser = auth()->user() ?? auth('empresa')->user();
    ?>
    <?php if($currentUser): ?>
      <div class="flex items-center">
        <div class="w-9 h-9 bg-primary-600 rounded-full flex items-center justify-center text-white">
          <i class="fa-solid fa-user text-xs"></i>
        </div>
        <div class="ml-3 leading-tight">
          <p class="text-sm font-medium"><?php echo e($currentUser->name); ?></p>
          <p class="text-xs text-gray-500"><?php echo e($currentUser->email); ?></p>
        </div>
      </div>
    <?php endif; ?>
  </div>
</aside>
<?php /**PATH /Users/mac/Documents/projetos/AzoProtocolo/resources/views/layouts/sidebar-empresas.blade.php ENDPATH**/ ?>