<?php $__env->startSection('title', 'Editar Protocolo'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex items-center gap-2 text-sm text-gray-500">
        <a href="<?php echo e(route('protocolos.index')); ?>" class="hover:text-gray-700">Protocolos</a>
        <span>/</span>
        <span class="text-gray-700">Editar</span>
    </div>

    <div class="mt-2 flex items-center justify-between">
        <div>
            <h1 class="text-2xl font-semibold tracking-tight text-gray-900">Editar Protocolo</h1>
            <p class="text-sm text-gray-500">Atualize as informações do protocolo.</p>
        </div>
        <a href="<?php echo e(route('protocolos.index')); ?>" class="hidden sm:inline-flex items-center gap-2 text-sm px-3 py-2 rounded-lg border border-gray-200 text-gray-700 hover:bg-gray-50">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M7.78 4.22a.75.75 0 010 1.06L4.56 8.5H17a.75.75 0 010 1.5H4.56l3.22 3.22a.75.75 0 11-1.06 1.06l-4.5-4.5a.75.75 0 010-1.06l4.5-4.5a.75.75 0 011.06 0z" clip-rule="evenodd"/></svg>
            Voltar
        </a>
    </div>

    <?php if($errors->any()): ?>
        <div class="mt-4 rounded-lg border border-red-200 bg-red-50 text-red-800 px-4 py-3">
            <div class="font-medium">Ocorreram erros ao enviar o formulário:</div>
            <ul class="mt-2 list-disc list-inside text-sm">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <div class="mt-4 bg-white border border-gray-200 rounded-xl shadow-sm overflow-hidden">
        <div class="px-4 sm:px-6 py-4 border-b border-gray-200">
            <h2 class="text-base font-semibold text-gray-900">Dados do protocolo</h2>
        </div>
        <form method="POST" action="<?php echo e(route('protocolos.update', $protocolo)); ?>" class="px-4 sm:px-6 py-6 space-y-6" autocomplete="off">
            <?php echo $__env->make('protocolos._form', ['protocolo' => $protocolo], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.gestao', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/Documents/projetos/AzoProtocolo/resources/views/protocolos/edit.blade.php ENDPATH**/ ?>