<?php $__env->startSection('title', 'Relatórios'); ?>

<?php $__env->startSection('content'); ?>
  <form method="GET" action="<?php echo e(route('relatorios.index')); ?>" class="mb-6 flex flex-wrap gap-2 items-end">
    <div>
      <label class="block text-sm text-gray-600 mb-1">Protocolo</label>
      <select name="protocolo_id" class="border-gray-300 rounded-lg">
        <option value="" <?php if(!$protocoloId): echo 'selected'; endif; ?>>Selecione</option>
        <?php $__currentLoopData = $protocolos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($prot->id); ?>" <?php if($prot->id == $protocoloId): echo 'selected'; endif; ?>><?php echo e($prot->nome); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
    </div>
    <?php if($periodos->isNotEmpty()): ?>
      <div>
        <label class="block text-sm text-gray-600 mb-1">Período</label>
        <select name="periodo_id" class="border-gray-300 rounded-lg">
          <option value="" <?php if(!$periodoId): echo 'selected'; endif; ?>>Selecione</option>
          <?php $__currentLoopData = $periodos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $per): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($per->id); ?>" <?php if($per->id == $periodoId): echo 'selected'; endif; ?>><?php echo e($per->inicio->format('d/m/Y')); ?> - <?php echo e($per->fim->format('d/m/Y')); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
    <?php endif; ?>
    <div>
      <button type="submit" class="px-4 py-2 bg-primary-600 text-white rounded-lg">Gerar Relatório</button>
    </div>
  </form>

  <?php if(!empty($analitico)): ?>
    <div class="space-y-6">
      <?php $__currentLoopData = $analitico; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pergunta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="bg-white rounded-xl border border-gray-200 p-5 shadow-soft">
          <h3 class="font-semibold mb-4"><?php echo e($pergunta['texto']); ?></h3>
          <ul class="space-y-2">
            <?php $__currentLoopData = $pergunta['opcoes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opcao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li class="flex justify-between text-sm text-gray-600">
                <span><?php echo e($opcao['texto']); ?></span>
                <span><?php echo e($opcao['quantidade']); ?></span>
              </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
  <?php elseif($protocoloId && $periodoId): ?>
    <p class="text-sm text-gray-500">Sem respostas para os filtros selecionados.</p>
  <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.empresas', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/Documents/projetos/AzoProtocolo/resources/views/relatorios/index.blade.php ENDPATH**/ ?>