<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($protocolo->nome); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {50: '#f0f9ff',500: '#3b82f6',600: '#2563eb',700: '#1d4ed8'}
                    }
                }
            }
        }
    </script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body class="min-h-screen bg-gradient-to-br from-blue-50 via-white to-cyan-50">
<header class="bg-white shadow-sm border-b border-gray-200">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex items-center justify-between h-16">
            <div class="flex items-center">
                <img src="<?php echo e(asset('logoazo.webp')); ?>" alt="Logo" class="h-8 w-auto">
                <span class="ml-3 text-lg font-semibold text-gray-900"><?php echo e($protocolo->nome); ?></span>
            </div>
            <div class="flex items-center space-x-4">
                <span class="text-sm text-gray-600"><?php echo e($empresa->name); ?></span>
                <div class="w-8 h-8 bg-gray-300 rounded-full flex items-center justify-center">
                    <i class="fas fa-user text-gray-600 text-sm"></i>
                </div>
            </div>
        </div>
    </div>
</header>

<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <form id="respostaForm" method="POST" action="<?php echo e(route('protocolo.responder.salvar', $token)); ?>">
        <?php echo csrf_field(); ?>
        <div id="introCard" class="bg-white rounded-lg shadow-sm border border-gray-200 p-6 mb-8">
            <div class="mb-4">
                <p class="text-gray-600"><?php echo e($protocolo->introducao); ?></p>
            </div>
            <div class="grid grid-cols-1 gap-4 mb-4 <?php echo e($empresa->setores->count() ? 'md:grid-cols-4' : 'md:grid-cols-3'); ?>">
                <div>
                    <label class="block text-sm font-medium text-gray-700">Nome (opcional)</label>
                    <input type="text" name="nome" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">CPF</label>
                    <input type="text" name="cpf" class="w-full rounded-lg border border-gray-300 px-3 py-2" required>
                </div>
                <?php if($empresa->setores->count()): ?>
                <div>
                    <label for="setor_id" class="block text-sm font-medium text-gray-700">Setor</label>
                    <select name="setor_id" id="setor_id" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                        <option value="">Selecione</option>
                        <?php $__currentLoopData = $empresa->setores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($setor->id); ?>"><?php echo e($setor->nome); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <?php endif; ?>
                <div class="flex items-center mt-4 md:mt-0">
                    <input type="checkbox" name="compartilhar" id="compartilhar" class="rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                    <label for="compartilhar" class="ml-2 text-sm text-gray-600">Aceito compartilhar meus resultados com a empresa de forma anônima</label>
                </div>
            </div>
            <div class="flex items-center justify-end">
                <button type="button" id="startBtn" class="px-4 py-2 bg-blue-600 text-white rounded-lg">Continuar</button>
            </div>
        </div>

        <div id="questionCard" class="bg-white rounded-lg shadow-lg border border-gray-200 p-8 mb-8 hidden">
            <div class="mb-4">
                <div class="flex justify-between text-sm text-gray-600 mb-2">
                    <span>Progresso</span>
                    <span id="progressText">1 de 1 perguntas</span>
                </div>
                <div class="w-full bg-gray-200 rounded-full h-2">
                    <div id="progressBar" class="bg-gradient-to-r from-blue-500 to-cyan-500 h-2 rounded-full transition-all duration-300" style="width:0%"></div>
                </div>
            </div>
            <div class="mb-6">
                <div class="flex items-center justify-between mb-4">
                    <span id="questionBadge" class="text-sm font-medium text-blue-600 bg-blue-50 px-3 py-1 rounded-full">Pergunta 1</span>
                    <span class="text-sm text-gray-500">Obrigatória</span>
                </div>
                <h2 id="questionTitle" class="text-xl font-semibold text-gray-900 mb-3"></h2>
            </div>
            <div id="answerOptions" class="space-y-3"></div>
            <div class="mt-8 flex items-center justify-between">
                <button type="button" id="prevBtn" class="px-4 py-2 text-sm border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50" disabled>Anterior</button>
                <button type="button" id="nextBtn" class="px-4 py-2 text-sm bg-blue-600 text-white rounded-lg hover:bg-blue-700">Próxima</button>
            </div>
        </div>
        <input type="hidden" name="answers" id="answersInput">
    </form>
</div>

<script>
    const questions = <?php echo json_encode($questions, 15, 512) ?>;
    const checkCpfUrl = '<?php echo e(route('protocolo.responder.check', $token)); ?>';
    let currentQuestion = 0;
    let answers = {};

    function loadQuestion(index) {
        const question = questions[index];
        document.getElementById('questionBadge').textContent = `Pergunta ${index + 1}`;
        document.getElementById('questionTitle').textContent = question.title;
        const progress = ((index + 1) / questions.length) * 100;
        document.getElementById('progressBar').style.width = `${progress}%`;
        document.getElementById('progressText').textContent = `${index + 1} de ${questions.length} perguntas`;
        const optionsContainer = document.getElementById('answerOptions');
        optionsContainer.innerHTML = '';
        question.options.forEach(option => {
            const label = document.createElement('label');
            label.className = 'flex items-center p-4 border border-gray-200 rounded-lg hover:bg-gray-50 hover:border-blue-300 cursor-pointer transition duration-200 group';
            const isChecked = answers[question.id] === option.value ? 'checked' : '';
            label.innerHTML = `<input type="radio" name="answer" value="${option.value}" class="w-4 h-4 text-blue-600 border-gray-300 focus:ring-blue-500" ${isChecked}><div class=\"ml-4\"><div class=\"text-gray-900 font-medium group-hover:text-blue-700\">${option.label}</div></div>`;
            optionsContainer.appendChild(label);
        });
        document.querySelectorAll('input[name="answer"]').forEach(radio => {
            radio.addEventListener('change', function() {
                answers[question.id] = parseInt(this.value);
                updateNavigation();
            });
        });
    }

    function updateNavigation() {
        const prevBtn = document.getElementById('prevBtn');
        const nextBtn = document.getElementById('nextBtn');
        prevBtn.disabled = currentQuestion === 0;
        const answered = answers[questions[currentQuestion].id] !== undefined;
        nextBtn.disabled = !answered;
        if (currentQuestion === questions.length - 1) {
            nextBtn.textContent = 'Finalizar';
        } else {
            nextBtn.textContent = 'Próxima';
        }
    }

    document.getElementById('prevBtn').addEventListener('click', function() {
        if (currentQuestion > 0) {
            currentQuestion--;
            loadQuestion(currentQuestion);
            updateNavigation();
        }
    });

    document.getElementById('nextBtn').addEventListener('click', function() {
        if (currentQuestion < questions.length - 1) {
            currentQuestion++;
            loadQuestion(currentQuestion);
            updateNavigation();
        } else {
            completeProtocol();
        }
    });

    function completeProtocol() {
        document.getElementById('answersInput').value = JSON.stringify(answers);
        document.getElementById('respostaForm').submit();
    }

    document.getElementById('startBtn').addEventListener('click', function() {
        const cpf = document.querySelector('input[name="cpf"]').value;
        fetch(checkCpfUrl, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({ cpf })
        }).then(async res => {
            if (res.ok) {
                document.getElementById('introCard').classList.add('hidden');
                document.getElementById('questionCard').classList.remove('hidden');
                loadQuestion(currentQuestion);
                updateNavigation();
            } else {
                const data = await res.json().catch(() => ({}));
                alert(data.message || 'CPF não autorizado');
            }
        }).catch(() => alert('Erro ao verificar CPF'));
    });
</script>
</body>
</html>
<?php /**PATH /Users/mac/Documents/projetos/AzoProtocolo/resources/views/protocolos/resposta.blade.php ENDPATH**/ ?>