<?php $__env->startSection('title', 'Empresas'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between mt-2">
        <div>
            <h1 class="text-2xl font-semibold tracking-tight text-gray-900">Empresas</h1>
            <p class="text-sm text-gray-500">Gerencie empresas cadastradas.</p>
        </div>
        <div class="flex items-center gap-2">
            <a href="<?php echo e(route('empresas.create')); ?>" class="inline-flex items-center gap-2 bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg shadow">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z"/></svg>
                Nova Empresa
            </a>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div x-data="{show:true}" x-show="show" class="mt-4 rounded-lg border border-green-200 bg-green-50 text-green-800 px-4 py-3 flex items-start gap-3">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mt-0.5" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.857-9.809a.75.75 0 00-1.214-.882l-3.182 4.384-1.59-1.59a.75.75 0 10-1.06 1.06l2.25 2.25a.75.75 0 001.145-.089l3.651-5.134z" clip-rule="evenodd"/></svg>
            <div class="text-sm flex-1"><?php echo e(session('success')); ?></div>
            <button x-on:click="show=false" class="text-green-700/70 hover:text-green-900"><svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/></svg></button>
        </div>
    <?php endif; ?>

    <div class="mt-4 bg-white border border-gray-200 rounded-xl overflow-hidden shadow-sm">
        <div class="overflow-x-auto">
            <table class="min-w-full">
                <thead class="bg-gray-50 text-left text-xs font-semibold text-gray-600">
                        <tr>
                            <th class="px-6 py-3">Nome</th>
                            <th class="px-6 py-3">Contato</th>
                            <th class="px-6 py-3">Telefone</th>
                            <th class="px-6 py-3">Cidade</th>
                            <th class="px-6 py-3">Estado</th>
                            <th class="px-6 py-3">Email</th>
                            <th class="px-6 py-3 text-right">Ações</th>
                        </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <?php $__empty_1 = true; $__currentLoopData = $empresas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empresa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                          <tr class="hover:bg-gray-50">
                              <td class="px-6 py-4 text-gray-900"><?php echo e($empresa->name); ?></td>
                              <td class="px-6 py-4 text-gray-700"><?php echo e($empresa->contact_name); ?></td>
                              <td class="px-6 py-4 text-gray-700"><?php echo e($empresa->phone); ?></td>
                              <td class="px-6 py-4 text-gray-700"><?php echo e($empresa->city); ?></td>
                              <td class="px-6 py-4 text-gray-700"><?php echo e($empresa->state); ?></td>
                              <td class="px-6 py-4 text-gray-700"><?php echo e($empresa->email); ?></td>
                              <td class="px-6 py-4">
                                  <div class="flex justify-end gap-2">
                                      <a href="<?php echo e(route('empresas.setores.index', $empresa)); ?>" class="inline-flex items-center gap-1.5 px-3 py-1.5 text-sm rounded-lg border border-gray-200 text-gray-700 hover:bg-gray-50">
                                          <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path d="M4 4h12v2H4V4zm0 4h12v2H4V8zm0 4h12v2H4v-2z"/></svg>
                                          Setores
                                      </a>
                                      <a href="<?php echo e(route('empresas.edit', $empresa)); ?>" class="inline-flex items-center gap-1.5 px-3 py-1.5 text-sm rounded-lg border border-blue-200 text-blue-700 hover:bg-blue-50">
                                          <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L4 13.172V16h2.828l7.38-7.379-2.83-2.828z"/></svg>
                                          Editar
                                      </a>
                                      <form action="<?php echo e(route('empresas.destroy', $empresa)); ?>" method="POST" onsubmit="return confirm('Deseja excluir esta empresa?')">
                                          <?php echo csrf_field(); ?>
                                          <?php echo method_field('DELETE'); ?>
                                          <button type="submit" class="inline-flex items-center gap-1.5 px-3 py-1.5 text-sm rounded-lg border border-red-200 text-red-700 hover:bg-red-50">
                                              <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 100 2h.293l.853 10.236A2 2 0 007.139 18h5.722a2 2 0 001.993-1.764L15.707 6H16a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zm-1 6a1 1 0 112 0v6a1 1 0 11-2 0V8zm5 0a1 1 0 112 0v6a1 1 0 11-2 0V8z" clip-rule="evenodd"/></svg>
                                              Excluir
                                          </button>
                                      </form>
                                  </div>
                              </td>
                          </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                          <td colspan="7" class="px-6 py-16">
                                <div class="text-center">
                                    <div class="inline-flex h-12 w-12 items-center justify-center rounded-full bg-gray-100 text-gray-400">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" viewBox="0 0 24 24" fill="currentColor"><path d="M16 11c1.657 0 3 1.343 3 3v4h1a1 1 0 110 2H4a1 1 0 110-2h1v-4c0-1.657 1.343-3 3-3h8zm-4-8a4 4 0 110 8 4 4 0 010-8z"/></svg>
                                    </div>
                                    <h3 class="mt-3 text-sm font-semibold text-gray-900">Nenhuma empresa encontrada</h3>
                                    <p class="mt-1 text-sm text-gray-500">Cadastre uma nova empresa.</p>
                                    <div class="mt-4">
                                        <a href="<?php echo e(route('empresas.create')); ?>" class="inline-flex items-center gap-2 bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">Nova Empresa</a>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.gestao', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/Documents/projetos/AzoProtocolo/resources/views/empresas/index.blade.php ENDPATH**/ ?>