<?php

namespace Tests\Feature;

use App\Models\Empresa;
use App\Models\EmpresaProtocolo;
use App\Models\EmpresaProtocoloPeriodo;
use App\Models\Protocolo;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class EmpresaProtocoloPeriodoDeleteTest extends TestCase
{
    use RefreshDatabase;

    public function test_empresa_can_delete_periodo(): void
    {
        $empresa = Empresa::create([
            'name' => 'Empresa',
            'email' => 'empresa@example.com',
            'password' => bcrypt('secret'),
        ]);

        $protocolo = Protocolo::create([
            'nome' => 'Teste',
            'tipo' => 'simples',
            'status' => true,
            'permitir_pf' => true,
        ]);

        $ep = EmpresaProtocolo::create([
            'empresa_id' => $empresa->id,
            'protocolo_id' => $protocolo->id,
            'ativo' => true,
        ]);

        $periodo = EmpresaProtocoloPeriodo::create([
            'empresa_protocolo_id' => $ep->id,
            'inicio' => now()->toDateString(),
            'fim' => now()->addDay()->toDateString(),
            'token' => 'abc',
        ]);

        $response = $this->actingAs($empresa, 'empresa')
            ->from(route('empresa.protocolos.index'))
            ->delete(route('empresa.protocolos.periodos.destroy', $periodo));

        $response->assertRedirect(route('empresa.protocolos.index'));

        $this->assertDatabaseMissing('empresa_protocolo_periodos', [
            'id' => $periodo->id,
        ]);
    }
}

