<?php

namespace Tests\Feature;

use App\Models\Empresa;
use App\Models\EmpresaProtocolo;
use App\Models\EmpresaProtocoloPeriodo;
use App\Models\Protocolo;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ProtocoloLinkWithoutPermitPfTest extends TestCase
{
    use RefreshDatabase;

    public function test_link_works_even_without_permitir_pf(): void
    {
        $empresa = Empresa::create([
            'name' => 'Empresa',
            'email' => 'empresa@example.com',
            'password' => bcrypt('secret'),
        ]);

        $protocolo = Protocolo::create([
            'nome' => 'Teste',
            'tipo' => 'simples',
            'status' => true,
            'permitir_pf' => false,
        ]);

        $ep = EmpresaProtocolo::create([
            'empresa_id' => $empresa->id,
            'protocolo_id' => $protocolo->id,
            'ativo' => true,
        ]);

        EmpresaProtocoloPeriodo::create([
            'empresa_protocolo_id' => $ep->id,
            'inicio' => now()->subDay()->toDateString(),
            'fim' => now()->addDay()->toDateString(),
            'token' => 'abc',
        ]);

        $response = $this->get(route('protocolo.responder', 'abc'));

        $response->assertStatus(200);
    }
}
