<?php

namespace Tests\Feature;

use App\Models\Empresa;
use App\Models\Protocolo;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ProtocoloVisibilityTest extends TestCase
{
    use RefreshDatabase;

    public function test_protocolos_invisiveis_nao_aparecem_para_empresas(): void
    {
        $empresa = Empresa::create([
            'name' => 'Empresa',
            'email' => 'empresa@example.com',
            'password' => bcrypt('secret'),
        ]);

        $visivel = Protocolo::create([
            'nome' => 'Visivel',
            'tipo' => 'simples',
            'status' => true,
            'visivel_empresas' => true,
            'permitir_pf' => true,
        ]);

        $oculto = Protocolo::create([
            'nome' => 'Oculto',
            'tipo' => 'simples',
            'status' => true,
            'visivel_empresas' => false,
            'permitir_pf' => true,
        ]);

        $response = $this->actingAs($empresa, 'empresa')
            ->get(route('empresa.protocolos.index'));

        $response->assertOk();
        $response->assertSee('Visivel');
        $response->assertDontSee('Oculto');
    }

    public function test_empresa_nao_pode_ativar_protocolo_invisivel(): void
    {
        $empresa = Empresa::create([
            'name' => 'Empresa',
            'email' => 'empresa@example.com',
            'password' => bcrypt('secret'),
        ]);

        $protocolo = Protocolo::create([
            'nome' => 'Oculto',
            'tipo' => 'simples',
            'status' => true,
            'visivel_empresas' => false,
            'permitir_pf' => true,
        ]);

        $response = $this->actingAs($empresa, 'empresa')
            ->post(route('empresa.protocolos.toggle', $protocolo), ['ativo' => 1]);

        $response->assertStatus(403);
    }
}
